/*
 * server/server.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "Server.h"

#include <SDL/SDL.h>

#include <iostream>

void cleanup() {
	SDLNet_Quit();
}

int main( int argc, char ** argv ) {

        if ( argc < 2 ) {
                cout << "Usage: server <port>" << endl;
                exit(1);
        }

        int port = atoi( argv[1] );

        // Initialize SDL
        if ( SDL_Init(0) < 0 ) {
                cout << "Couldn't initialize SDL: " << SDL_GetError() << endl;
                exit(1);
	}
	atexit( SDL_Quit );

	/* Initialize the network */
	if ( SDLNet_Init() < 0 ) {
                cout << "Couldn't initialize net: " << SDLNet_GetError() << endl;
		exit(1);
	}
	atexit( cleanup );

        class Server * s = new Server( port );
        
        s->run( true );
        
        while ( true ) {
                SDL_Delay( 100000 );
        }

        delete s;
}
