/*
 * widgets/AbstractTableModel.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __TableModel_h__
#define __TableModel_h__

enum TableCellType {
        TABLE_CELL_ERROR,
        TABLE_CELL_CHAR_PTR,
        TABLE_CELL_ICON
};

class AbstractTableModel {
public:
        virtual int getColumnCount() const = 0;
        virtual const char * getColumnName( int col ) const = 0;
        virtual const int getRowCount() const = 0;
        virtual const void * getValueAt( int row, int col ) const = 0;
        virtual const enum TableCellType getColumnType( int col ) const = 0;
        virtual ~AbstractTableModel() {}
};

#endif
