/*
 * widgets/ButtonWidget.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __ButtonWidget_h__
#define __ButtonWidget_h__

#include "Widget.h"

class ButtonWidget : public Widget {

        const GLfloat * _unselectedBGColor;
        const GLfloat * _selectedBGColor;
        const GLfloat * _pressedBGColor;

        /**
         * pressed means the user is holding down the button.  
         * a button must be pressed and released to change state
         */

        bool _isPressed;
        bool _isToggleable;

        bool _isCheckbox;

        bool _drawBottomHighlight;

        /**
         * state indicates if the button is 'selected' or not
         */
        bool _isSelected;
        bool _isEnabled;

        class LabelWidget * _label;
public:
        
        inline const bool drawBottomHighlight() const { return _drawBottomHighlight; }
        inline const bool isPressed() const { return _isPressed; }
        inline const bool isToggleable() const { return _isToggleable; }
        inline const bool isSelected() const { return _isSelected; }

        const char * getLabelText() const;

        void setButtonColors( const GLfloat * unsel, const GLfloat *sel, const GLfloat *press );
        void setSelected( bool selected );
        void setDrawBottomHighlight( bool draw );
        void setToggleable( bool togg );
        void setCheckbox( bool check );

        ButtonWidget( int width, int height, const char *message = 0 );
        ~ButtonWidget();

        void paint();
        virtual bool mouseReleased( SDL_MouseButtonEvent * evt );
        virtual bool mousePressed( SDL_MouseButtonEvent * evt );
        virtual bool mouseExited( SDL_MouseMotionEvent * evt );
        
};

#endif
