/*
 * client/CharacterScreen.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __CharacterScreen_h__
#define __CharacterScreen_h__


#include "Client.h"

#include "GenericScreen.h"

#include "../widgets/WidgetEvents.h"
#include "../widgets/LabelWidget.h"

#include "../server/Character.h"

class CharacterScreen : public GenericScreen {

        class PaperDollWidget * _paperDoll;
        class InventoryWidget * _inventory;
        class LabelWidget * _titleBar;
        class StatsWidget * _statsWidget;
        class PointsWidget * _pointsWidget;
        class InfoPanel    * _infoPanel;
        class ButtonWidget * _closeButton;
        class SkillsPanel  * _skillsPanel;

public:
        CharacterScreen( int x, int y );
        ~CharacterScreen();
        void updateWidget();

};

class PaperDollWidget : public Widget {
        int _numItems;
        class ItemWidget ** _items;
public:
        PaperDollWidget( int x, int y );
        ~PaperDollWidget();
        void updateData( const class Player * p );
};


class InventoryWidget : public Widget {
        int _numItems;
        class ItemWidget ** _items;
        int _rows;
        int _cols;

public:
        InventoryWidget( int x, int y, int rows, int cols, int padx, int pady );
        ~InventoryWidget();
        void updateData( const class Player * p );
};

class StatsWidget : public Widget {
        class LabelWidget _label;
        class LabelWidget _statLabelLabels[ NUM_STATS ];
        class LabelWidget _statLabels[ NUM_STATS ];
public:
        StatsWidget( int x, int y );
        ~StatsWidget();
        void updateData( const class Player * p );
};

class PointsWidget : public Widget {
        static const int NUM_POINTS = 6;
        class LabelWidget _label;
        class LabelWidget _pointLabelLabels[ NUM_POINTS ];
        class LabelWidget _pointLabels[ NUM_POINTS ];
public:
        PointsWidget( int x, int y );
        ~PointsWidget();
        void updateData( const class Player * p );
};

class ItemWidget : public Widget {
public:
        enum ItemWidgetType {
                INVENTORY,
                EQUIPMENT
        };

private:

        class Item * _item;
        int _index;

        ItemWidgetType _type;

                
public:

        
        ItemWidget( int x, int y, int index, ItemWidgetType type );
        
        inline const int getIndex() const { return _index; }

        class Item * setItem( class Item * item );
        virtual class Draggable * performDNDPickup( DNDGestureEvent * evt );
        virtual bool performDNDDrop(   DNDGestureEvent * evt, class Draggable ** pickup );
        ~ItemWidget();
};

class InfoPanel : public Widget {
        class Widget * _info;
        class LabelWidget * _infoLabel;
        class Widget * _imageWidget;
        class TextPaneWidget * _textPane;
        class ScrollpaneWidget * _scroll;
        class LabelWidget * _panelLabel;
public:
        InfoPanel( int x, int y );
        ~InfoPanel();
};

class SkillsPanel : public Widget {
        class DefaultTableModel * _model;
        class ScrollpaneWidget * _scroll;
        class LabelWidget * _label;
        class TableWidget * _table;
public:
        SkillsPanel( int x, int y );
        ~SkillsPanel();
};
#endif
