/*
 * client/ClientLightmap.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "ClientLightmap.h"
#include <GL/glu.h>
#include <iostream>

#include "../util/TextureManager.h"
#include "../util/Texload.h"
#include "../server/Lightmap.h"
#include "../GraphicsState.h"

ClientLightmap::ClientLightmap( class Lightmap * lm ) {

        _tex = 0;
        
        lm->needs_rebind = false;
        
        if ( !lm->rgb_pixels )
                return;

        Texload::applyGamma( lm->static_pixels, g_state.gamma, lm->size[0], lm->size[1], 3 );
        Texload::applyGamma( lm->rgb_pixels, g_state.gamma, lm->size[0], lm->size[1], 3 );

        GLenum gl_error;

        glGenTextures( 1, &_tex );

        glPixelStorei( GL_UNPACK_ROW_LENGTH, lm->size[0] );
        glBindTexture( GL_TEXTURE_2D, _tex );

        glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP );
        glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP );
        
        //
        // TODO: make lightmap mag filter mode toggleable
        //
        
        glTexParameterf(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );
        glTexParameterf( GL_TEXTURE_2D,
                         GL_TEXTURE_MIN_FILTER,
                         GL_LINEAR );

        glTexEnvi( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );
        
        if( ( gl_error = glGetError() ) != GL_NO_ERROR ) {
                cout << " :: TextureObject() stage 2 GL error " << (long) gl_error << endl;
        } 
                
        glTexImage2D( GL_TEXTURE_2D,
                      0,
                      3,
                      lm->size[0],
                      lm->size[1],
                      0,
                      GL_RGB,
                      GL_UNSIGNED_BYTE,
                      lm->rgb_pixels );

}

void ClientLightmap::rebindTexture( class Lightmap * lm ) {
        
        if ( ! lm->needs_rebind )
                return;
        
        lm->needs_rebind = false;
        
        glBindTexture( GL_TEXTURE_2D, _tex );
        glPixelStorei( GL_UNPACK_ROW_LENGTH, lm->size[0] );

        glTexSubImage2D( GL_TEXTURE_2D,
                         0,
                         0,
                         0,
                         lm->size[0],
                         lm->size[1],
                         GL_RGB,
                         GL_UNSIGNED_BYTE,
                         lm->rgb_pixels );
        glFlush();

}




