/*
 * client/GenericMenu.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */


#include "GenericMenu.h"

#include "../widgets/ButtonWidget.h"
#include "../widgets/LabelWidget.h"
  
#include <string>

GenericMenu::GenericMenu( int w, int h, 
                          const char * name, 
                          int num_buttons,
                          const char ** button_labels,
                          const Client::State * states,
                          const char * escape_label,
                          const Client::State escape_state )
        : GenericScreen( w, h, escape_state, escape_state )
{
        _escapeButton = 0;
        _escapePanel  = 0;

        _numButtons = num_buttons;

        const int MENU_WIDTH      = w / 2;

        const int BUTTON_SIZE[]   = { MENU_WIDTH * 3 / 4, h / 10 };
        const int BUTTON_MARGIN[] = { MENU_WIDTH / 8,     h / 40 };

        string aname = "Generic Menu:[";
        aname.append( name );
        aname.append( "]" );
        
        _name = strdup( aname.c_str() );

        _buttons = new ButtonWidget * [ num_buttons ];
        _states  = new Client::State[ num_buttons ];

        _panel = new Widget( MENU_WIDTH, 
                             ( num_buttons * BUTTON_SIZE[1] ) + 
                             ( num_buttons + 1 ) * BUTTON_MARGIN[1] );
                             
        _panel->setOpaque( true );
        
        int buttPos = BUTTON_MARGIN[1];
        
        for ( int i = 0; i < num_buttons; ++i ) {
                _buttons[i] = new ButtonWidget( BUTTON_SIZE[0], BUTTON_SIZE[1], button_labels[i] );
                _buttons[i]->addWidgetEventListener( this );
                
                _states[i]  = states[i];
                _panel->add( _buttons[i], BUTTON_MARGIN[0], buttPos );
                buttPos += BUTTON_MARGIN[1] + BUTTON_SIZE[1];
        }

        _label = new LabelWidget( MENU_WIDTH, BUTTON_SIZE[1], name );
        _label->setOpaque( true );

        add( _label,
             ( _size[0] - MENU_WIDTH ) / 2, 
             _size[1] -  BUTTON_SIZE[1] - BUTTON_MARGIN[1] );
        
        add( _panel, 
             _label->getPos()[0],
             _label->getPos()[1] - _panel->getSize()[1] - BUTTON_MARGIN[1] );
 
        if ( escape_label ) {
                // margins on the escape panel are 1/2 size vertically
                _escapePanel  = new Widget( MENU_WIDTH,
                                            BUTTON_SIZE[1] + BUTTON_MARGIN[1] );
                _escapePanel->setOpaque( true );

                _escapeButton = new ButtonWidget( BUTTON_SIZE[0], BUTTON_SIZE[1], escape_label );

                _escapePanel->add( _escapeButton, BUTTON_MARGIN[0], BUTTON_MARGIN[1] / 2 );
                add( _escapePanel, 
                     _label->getPos()[0],
                     BUTTON_MARGIN[1] * 3 );

                _escapeButton->addWidgetEventListener( this );
        }
                
        _preferredPos[0] = 0;
        _preferredPos[1] = 0;

        acceptEventType( EVENT_ACTION, true );
}

GenericMenu::~GenericMenu() {
        for ( int i = 0; i < _numButtons; ++i ) {
                delete _buttons[i];
                _buttons[i] = 0;
        }
        delete[] _buttons;
        _buttons = 0;
        delete[] _states;
        _states = 0;
        delete _label;
        _label = 0;
        delete _name;
        _name = 0;
        delete _panel;
        _panel = 0;

        if ( _escapePanel ) {
                delete _escapePanel;
                _escapePanel = 0;
        }

        if ( _escapeButton ) {
                delete _escapeButton;
                _escapeButton = 0;
        }
}

void GenericMenu::handleEvent( const class WidgetEvent *evt ) {
        if ( evt->getType() == EVENT_ACTION ) {
                const void * source = evt->getSource();
                
                if ( source == _escapeButton ) {
                        doEscapeAction();
                        return;
                }
                
                for ( int i = 0; i < _numButtons; ++i ) {
                        if ( source == _buttons[i] ) {
                                Client::getInstance()->setDesiredState( _states[i] );
                                return;
                        }
                }
        }
}

