/*
 * client/GenericScreen.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "GenericScreen.h"

#include "../widgets/WidgetManager.h"

GenericScreen::GenericScreen( int w, int h, Client::State escape, Client::State close )
        : Widget( w, h ) {
        _escapeState = escape;
        _closeState = close;
}

void GenericScreen::setEscapeState( Client::State escape ) {
        _escapeState = escape;
}

void GenericScreen::setCloseState( Client::State close ) {
        _closeState = close;
}

void GenericScreen::doEscapeAction() {
        Client::getInstance()->setDesiredState( _escapeState );
}

void GenericScreen::doCloseAction() {
        Client::getInstance()->setDesiredState( _closeState );
}

bool GenericScreen::keyPressed(   SDL_KeyboardEvent * evt, int x, int y ) {

        if ( evt->keysym.sym == SDLK_ESCAPE ) {
                // cancel drag-n-drop
                WidgetManager::getInstance()->attemptDNDDrop( x, y, true );
                doEscapeAction();
                return true;
        }
        return Widget::keyPressed( evt, x, y );
}
