/*
 * util/AbstractFont.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "GFX.h"
#include "AbstractFont.h"
#include <algorithm>

const string AbstractFont::NAME = "AbstractFont";

AbstractFont::AbstractFont( const char * const fontName ) throw ( class Exception ) {

        _fontName      = fontName;
        _glyphsIndex   = 0;
        _numGlyphLists = 0;
}

bool AbstractFont::initGlyphLists( int num ) {

        if ( _glyphsIndex && _numGlyphLists ) {
                glDeleteLists( _glyphsIndex, _numGlyphLists );
        }
        
        _glyphsIndex = 0;
        _numGlyphLists = 0;
        
        _glyphsIndex = glGenLists( num );

        GLenum gl_error;

        if ( ( gl_error = glGetError() ) ) {
                cout << " :: AbstractFont::AbstractFont() gl_error 1 " << (long) gl_error << endl;
                return false;
        }
        else if ( _glyphsIndex == 0 ) {
                cout << " :: AbstractFont::AbstractFont() unable to create " << num << " glyph lists." << endl;
                return false;
        }
        
        _numGlyphLists = num;
        return true;
}

unsigned int AbstractFont::getStringWidth( const char * const str ) const {
        
        int total_width = 0;
        
        for ( const char *ptr = str; *ptr; ++ptr ) {
                total_width += _widths[ *ptr ];
        }
        
        return total_width;
}

/**
 * maxlen default 0
 */

void AbstractFont::drawString( const char * const str, int maxlen ) const {

        startStringDraw();

        int len = strlen( str );

        if ( maxlen )
                len = min( len, maxlen );

        glCallLists( len, GL_BYTE, str );
        
        endStringDraw();
}

void AbstractFont::startStringDraw() const {

        glListBase( _glyphsIndex );
}

void AbstractFont::endStringDraw() const {
}

AbstractFont::~AbstractFont() {
        if ( _glyphsIndex && _numGlyphLists )
                glDeleteLists( _glyphsIndex, _numGlyphLists );
}
