/*
 * widgets/Draggable.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Draggable_h__
#define __Draggable_h__

#include <string>

class Draggable {
        string _type;
        const class TextureObject * _icon;
        void * _obj;
public:
        Draggable( const char * type, const class TextureObject * icon, void * obj );
                
        const string getType() const { return _type; }
        const class TextureObject * getIcon() const { return _icon; }
        void * getObject() { return _obj; }
};

struct DNDGestureEvent {
        int x, y;
        class Draggable * draggable;
        DNDGestureEvent( int ax, int ay, class Draggable * aDraggable ) 
                : x(ax), y(ay), draggable( aDraggable ) {}
};

class DNDGestureListener{
protected:  
        virtual bool isDNDDropOk(      class DNDGestureEvent * evt ) = 0;
        /**
         *
         */
        virtual class Draggable * performDNDPickup( class DNDGestureEvent * evt ) = 0;
        /**
         * a DND drop action can force a pickup, thus the return parameter value value
         */
        virtual bool performDNDDrop(   class DNDGestureEvent * evt, class Draggable ** d ) = 0;
};

#endif

