/*
 * widgets/TextFieldWidget.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __TextFieldWidget_h__
#define __TextFieldWidget_h__

#include <string>

#include "Widget.h"

class TextFieldWidget : public Widget {
        string _text;

        unsigned int _point;
        int _mark;
        
        unsigned int _scrolledTo;
        unsigned int _numColumns;
        unsigned int _fontWidth;

        static const size_t MAX_INPUT_LEN = 1024;
        
public:

        static const char * const HISTORY_RECALL_UP_COMMAND;
        static const char * const HISTORY_RECALL_DOWN_COMMAND;

        TextFieldWidget( int w, int h );
        
        virtual bool keyPressed( SDL_KeyboardEvent * evt, int x, int y);

        /**
         * set the text in the TextFieldWidget
         * @param str can be null, erases field
         */
        
        void setText( const char * str );

        /**
         * returns a c string.  the string should be copied immediately if the
         * client must save it for future use, because it can change.
         */
        const char * getText() const { return _text.c_str(); }

        void paint();
        
};

#endif
