/*
 * widgets/WidgetManager.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __WidgetManager_h__
#define __WidgetManager_h__

#ifdef WIN32
#include <windows.h>
#endif

#include <SDL/SDL_mixer.h>
#include "EventListeners.h"

#include "../util/Vector.h"

class Widget;

class WidgetManager : 
        public KeyListener, 
        public MouseButtonListener, 
        public MouseMotionListener {

        class Widget * _toplevelWidget;
        class ConsoleWidget * _consoleWidget;
       
        
        bool _consoleEnabled;

        WidgetManager( int x, int y );
        static class WidgetManager * _instance;

        class Draggable * _draggable;
        bool _dndPickupStart;
        int  _dndPickupPos[2];
        bool _dndDragInProgress;
        class DNDGestureEvent * _dndPickupGesture;

        class SDL_mutex * _mutex;

        Vector< class Widget * > _updateWidgets;

        Mix_Chunk * _dndDropFailedSound;
        
        class Vector<class Widget *>  _postUpdateDeleteWidgets;
public:
        virtual ~WidgetManager();

        void add( class Widget * w, int x, int y );
        bool removeWidget( class Widget * w );

        void display();
        const int * getSize() const;

        class Widget * getToplevelWidget() { return _toplevelWidget; }

        bool setConsoleEnabled( bool enabled );

        inline bool isConsoleEnabled() const { return _consoleEnabled; }
        inline bool toggleConsole() { return setConsoleEnabled( !_consoleEnabled  ); }
        inline const class Draggable * getDraggable() const { return _draggable; }

        static WidgetManager * getInstance( int x, int y );
        static WidgetManager * getInstance() { return _instance; }
        
        bool attemptDNDDrop( int x, int y, bool cancel );

        // class KeyListener
        bool keyPressed(    SDL_KeyboardEvent * evt, int x, int y );
        bool keyReleased(   SDL_KeyboardEvent * evt );
        // class MouseButtonListener
        bool mousePressed(  SDL_MouseButtonEvent * evt );
        bool mouseReleased( SDL_MouseButtonEvent * evt );
        // class MouseMotionListener {
        bool mouseMoved(    SDL_MouseMotionEvent * evt );
        bool mouseEntered(  SDL_MouseMotionEvent * evt );
        bool mouseExited(   SDL_MouseMotionEvent * evt );

        bool updateWidgets();

        void schedulePostUpdateDelete( class Widget * w );
        void addUpdateWidget( class Widget * w );
        void removeUpdateWidget( class Widget * w );
};

#endif
