/*
 * server/LineDef.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __LineDef_h__
#define __LineDef_h__

#include "../util/Array.h"

/**
 * a line in 2d space (x-y)
 */

#include "Script.h"

struct LineDef {
        
        static const short REPEATABLE = 0x0001;
        static const short FRONT_OK   = 0x0002;
        static const short BACK_OK    = 0x0004;
        static const short PLAYER_OK  = 0x0008;
        static const short MONSTER_OK = 0x0010;
        static const short ITEM_OK    = 0x0020;
        static const short TRIPPED    = 0x8000;

        class SideDef * sides[2];
        float * verts[2];
        bool modified;
        float length;
        
        short trigger_flags;
        class Script * script;
        
        LineDef();
        
        void load( class istream & is, 
                   const class Array<float *> & vs,
                   const class Array<class SideDef *> & ss,
                   const class Zone * zone );

        void writeLine( class ostream & os, const class Zone * zone ) const;
        
        bool isTriggerFlagged( short bit ) const { return trigger_flags & bit; }
        
        friend class ostream & operator<<( class ostream &os, const class LineDef & line );

        bool isTriggerOk( bool front, bool ispc, bool isitem ) const {
                
                return ! ( script == 0 ||
                           script->running || 
                           ( isTriggerFlagged( TRIPPED ) && ! isTriggerFlagged( REPEATABLE ) ) ||
                           ( ( front && !isTriggerFlagged( FRONT_OK ) ) ||
                             ( !front && !isTriggerFlagged( BACK_OK ) ) ) ||
                           ( ispc && !isTriggerFlagged( PLAYER_OK ) ) ||
                           ( isitem && ! isTriggerFlagged( ITEM_OK ) ) ||
                           ( !ispc && !isTriggerFlagged( MONSTER_OK ) ) );
        }
};
#endif
