/*
 * util/ModelManager.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "ModelManager.h"

class md2_model_t * ModelManager::_models[ MAX_MODELS ];
int ModelManager::_num_models = 0;

const char * const ModelManager::MODEL_DIR = "lib/gfx/models/";

class md2_model_t * ModelManager::getModel( const char * name ) {
        
        md2_model_t * model = findModel( name );

        if ( model == 0 ) {

                if ( _num_models >= MAX_MODELS ) {
                        cout << " :: WARNING: out of model allocation slots" << endl;
                        return _models[0];
                }

                model = new md2_model_t( MODEL_DIR, name ? name : "null" );

                _models[ _num_models++ ] =  model;

        }
        return model;
}

void ModelManager::purge() {

        while ( _num_models ) {
                _models[ --_num_models ] = 0;
        }

}
