/*
 * util/TextureManager.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "GFX.h"
#include "TextureObject.h"
#include "Texload.h"

#include <GL/glu.h>

#include <iostream>
#include "../GraphicsState.h"

ostream & operator<<( ostream & os, const class TextureObject & to ) {
        os << "TextureObject:[ " 
           << to._name << ":" << (int) to._format
           << ", index=" << to._index 
           << ", size=" << to._size[0] << "x" << to._size[1] << ", ok=" << to._ok << endl;
        return os;
}

TextureObject::~TextureObject() {
        if ( _name )
                free( _name );
        // TODO: delete gl texture object too

}

TextureObject::TextureObject( const char * name, GLenum format )
        : _index( 0 ),
          _ok( false )
{
        
        _name = strdup( name );
        _format = format;

        GLubyte * pixels = 0;
        int components = 0;
        string filename = GFX::DIR + ( _name ? _name : "" );
        
        if ( _name == 0 || ! strcmp( _name, "textures/null" ) ) {
                _size[0] = _size[1] = 0;
                _index = 0;
                return;
        }
        else {
                _size[0] = _size[1] = 1;
        
                if ( _format == GL_LUMINANCE_ALPHA ) {
                        filename += ".pgm";
                        pixels = Texload::loadPGM( filename.c_str(), &_size[0], &_size[1], true );

                        //
                        // expand pixels from luminance (grayscale) to luminance-alpha
                        //
                        
                        cout << " expanding pixels " << endl;
                        
                        if ( pixels ) {
                                GLubyte * la_pixels = new GLubyte[ _size[0] *_size[1] * 2 ];
                                //                        GLubyte * la_pixels = (GLubyte *) malloc( sizeof( GLubyte ) * _size[0] *_size[1] * 2 );
                                
                                for ( int i = 0; i < _size[0] *_size[1]; ++i ) {
                                        la_pixels[i*2     ] = pixels[i];
                                        la_pixels[i*2 + 1 ] = pixels[i];
                                }
                                
                                delete[] pixels;
                                //                        free( pixels );
                                pixels = la_pixels;

                        }
                        
                        cout << " expanded" << endl;

                        components = 2;
                }
                /*
        else if ( _format == GL_RGB ) {
                filename += ".ppm";
                pixels = Texload::loadPPM( filename.c_str(), &_size[0], &_size[1], true );
                components = 3;

        }
        */
                else if ( _format == GL_RGB || _format == GL_RGBA ) {
                        filename += ".png";
                        pixels = Texload::loadPNG( filename.c_str(), &_size[0], &_size[1], &components, true );

                        Texload::applyGamma( pixels, g_state.gamma, _size[0], _size[1], components );
                        
                        if ( components == 4 )
                                _format = GL_RGBA;
                        else
                                _format = GL_RGB;
                        
                }

                else {
                        cout << " :: Unsupported format in TextureObject" << endl;
                        return;
                }

                if ( ! pixels ) {
                        cout << " :: TextureObject load of " << filename << " failed." << endl;
                        return;
                }
        }        

        cout << " :: new Texture:" << _name << endl << flush;

        GLenum gl_error;
                
        glGenTextures( 1, &_index );

        glPixelStorei( GL_UNPACK_ROW_LENGTH, _size[0] );
        glBindTexture( GL_TEXTURE_2D, _index );

        glTexEnvi(       GL_TEXTURE_ENV,  GL_TEXTURE_ENV_MODE,   GL_MODULATE );
        glTexParameterf( GL_TEXTURE_2D,   GL_TEXTURE_MIN_FILTER, GL_LINEAR );
        glTexParameterf( GL_TEXTURE_2D,   GL_TEXTURE_MAG_FILTER, GL_LINEAR );
        
        if ( _format == GL_RGB ) {
                
                glTexParameterf( GL_TEXTURE_2D,
                                 GL_TEXTURE_MIN_FILTER,
                                 GL_LINEAR_MIPMAP_LINEAR );
                
                int mipval = gluBuild2DMipmaps( GL_TEXTURE_2D,
                                                components,
                                                _size[0],
                                                _size[1],
                                                _format,
                                                GL_UNSIGNED_BYTE,
                                                pixels );

                if ( mipval != 0 ) {
                        cout << " error building mipmaps: " << mipval << endl;
                }
        }
        else {
              
                glTexImage2D( GL_TEXTURE_2D, 
                              0,              // base image number (mipmap index)
                              components,     // color components
                              _size[0],       // width 
                              _size[1],       // height 
                              0,              // border
                              _format,
                              GL_UNSIGNED_BYTE, 
                              pixels );
        }

        delete[] pixels;
        //        free( pixels );
        pixels = 0;

        if( ( gl_error = glGetError() ) != GL_NO_ERROR ) 
                cout << " :: TextureObject() stage 3 GL error " << (long) gl_error << endl;

        //        glPopMatrix();

        _ok = true;
}
