/*
 * widgets/DefaultTableModel.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "DefaultTableModel.h"
#include <string>

DefaultTableModel::DefaultTableModel( int rows, 
                                      int cols,
                                      const char ** colNames,
                                      const enum TableCellType * types,
                                      void ** values )
        : _numCols( cols ), 
        _numRows( rows ) {

        _colNames = new char * [ _numCols ];
        _types    = new TableCellType[ _numCols ];
        
        for ( int i = 0; i < _numCols; ++i ) {
                _colNames[i] = strdup( colNames[i] );
                _types[i]    = types[i];
        }

        _values   = values;

}

DefaultTableModel::~DefaultTableModel() {

        for ( int i = 0; i < _numCols; ++i ) {
                free( _colNames[i] );
                _colNames[i] = 0;
        }

        delete[] _colNames;
        _colNames = 0;
        
}
