/*
 * widgets/TableWidget.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __TableWidget_h__
#define __TableWidget_h__

#include "Widget.h"
#include "AbstractTableModel.h"

class TableWidget : public Widget {
        class TableHeader * _header;
        class AbstractTableModel * _model;
        
        int * _colWidths;
        int _rowHeight;

public:

        /**
         * causes adjustment of header
         */
        void setColumnWidths( const int * widths );

        inline int getColumnWidth( int col ) {
                return _colWidths[ col ];
        }


        /**
         * creates a header if one does not exist
         * 
         */
        class TableHeader * getHeader();
        
        const class AbstractTableModel * getModel() const { return _model; }

        TableWidget( int w, int h, class AbstractTableModel * model );
        ~TableWidget();
        void paint();
};

class TableHeader : public Widget {
        class LabelWidget ** _labels;
        class TableWidget * _table;
public:
        TableHeader( class TableWidget * table );
        ~TableHeader();
};

#endif

