/*
 * client/Client.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Client_h__
#define __Client_h__

#include "../widgets/Widget.h"

class Client : public Widget {

public:
        enum State {
                CLIENT_ERROR,
                CLIENT_SPLASH,
                CLIENT_MENU_MAIN,
                CLIENT_MENU_NEW_GAME,
                CLIENT_MENU_LOAD_GAME,
                CLIENT_MENU_SETTINGS,
                CLIENT_TOWN,
                CLIENT_BLACKSMITH,
                CLIENT_CASTLE,
                CLIENT_TEMPLE,
                CLIENT_TAVERN,
                CLIENT_TRAINING,
                CLIENT_DUNGEON,
                CLIENT_MENU_DIFFICULTY_SINGLE,
                CLIENT_MENU_DIFFICULTY_MULTI,
                CLIENT_CHARACTER_SCREEN,
                CLIENT_START_EASY,
                CLIENT_START_NORMAL,
                CLIENT_START_HARD,
                CLIENT_IN_GAME,
                CLIENT_EXIT_GAME,
                CLIENT_MENU_IN_GAME,
                CLIENT_OPTIONS_CONTROLS,
                CLIENT_OPTIONS_VIDEO,
                CLIENT_OPTIONS_SOUND,
                CLIENT_QUIT
        };

private:
        State _currentState;
        State _desiredState;
        
        static class WidgetManager * _wm;
        float _bg[4];
        
        bool _isMultiplayer;
        
        class GenericMenu * _mainMenu;
        class GenericMenu * _newGameMenu;
        class GenericMenu * _difficultyMenu;
        class GenericMenu * _inGameMenu;
        class GenericMenu * _settingsMenu;

        class ControlsMenu * _controlsMenu;
        class SoundMenu    * _soundMenu;
        class VideoMenu    * _videoMenu;

        class CharacterScreen * _characterScreen;
        
        class DungeonScreen * _dungeonScreen;

        //        class MainMenu * _mainMenu;
        //        class NewGameMenu * _newGameMenu;

        static class Client * _instance;
        Client( class WidgetManager * wm, class DG * dg, const char * start_map );

        static class World  * _world;
        static class Player * _player;
        
        class DG * _dg;

public:
        
        ~Client();

        static class WidgetManager * getWidgetManager() { return _wm; }

        static class Client * createInstance( class WidgetManager * wm, class DG * dg, const char * start_map );
        static class Client * getInstance();
        static void shutdown();

        static class World * getWorld() { return _world; }
        static class Player * getPlayer() { return _player; }

        virtual bool mousePressed( SDL_MouseButtonEvent * evt );
        virtual bool mouseReleased( SDL_MouseButtonEvent * evt );
  
        // class KeyListener
        virtual bool keyPressed(    SDL_KeyboardEvent * evt, int x, int y );
        virtual bool keyReleased(   SDL_KeyboardEvent * evt );

        void setDesiredState( State state );
        
        void updateWidget();
};

#endif
