/*
 * client/ClientSector.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifdef WIN32
#include <windows.h>
#endif

#include "ClientSector.h"
#include "../server/Sector.h"
#include "../util/TextureManager.h"
#include "../server/Lightmap.h"

ClientSector::ClientSector(  const class Sector * sect ) {
        
        to[0] = TextureManager::getTexture( sect->floorTex, GL_RGB );
        to[1] = TextureManager::getTexture( sect->ceilingTex, GL_RGB );

        verts = new float[ sect->verts.length * 2 ];
        float * vptr = verts;

        for ( int i = 0; i < sect->verts.length; ++i ) {
                *(vptr++) = sect->verts[i][0];
                *(vptr++) = sect->verts[i][1];
        }

        textureVerts[0] = new float[ sect->verts.length * 2 ];
        textureVerts[1] = new float[ sect->verts.length * 2 ];
        
        float *tvptr[2] = { textureVerts[0], textureVerts[1] };
        
        for ( int i = 0; i < sect->verts.length; ++i ) {
                for ( int surf_i = 0; surf_i < 2; ++surf_i ) {
                        *(tvptr[surf_i]++) = sect->verts[i][0] / to[surf_i]->getSize()[0];
                        *(tvptr[surf_i]++) = sect->verts[i][1] / to[surf_i]->getSize()[1];
                }
        }

        lmVerts = new float[ sect->verts.length * 2 ];
        
        if ( sect->floor_lightmap && sect->ceiling_lightmap ) {

                float * lmvptr = lmVerts;
        
                for ( int i = 0; i < sect->verts.length; ++i ) {
                        *(lmvptr++) = 
                                ( sect->verts[i][0] - sect->_offset[0] ) / 
                                ( sect->floor_lightmap->size[0] * Lightmap::TEX_RES );
                        *(lmvptr++) = 
                                ( sect->verts[i][1] - sect->_offset[1] ) / 
                                ( sect->floor_lightmap->size[1] * Lightmap::TEX_RES );
                }
        }
        else {
                
                float * lmvptr = lmVerts;
        
                for ( int i = 0; i < sect->verts.length; ++i ) { 
                        *(lmvptr++) = *(lmvptr++) = 0;
                }
        }
}

ClientSector::~ClientSector() {
        delete[] verts;
        delete[] textureVerts[0];
        delete[] textureVerts[1];
        if ( lmVerts )
                delete[] lmVerts;
}

