#define __ClientState_cc__

#include "ClientState.h"
#include <SDL/SDL_mixer.h>

ClientState cl_state;

ClientState::ClientState() {
        mouse_sensitivity  = 0.4;
        fov                = 85;
        walk_speed         = 7;

        music_vol          = 50;
        sfx_vol            = 60;
        sfx_mix_vol        = MIX_MAX_VOLUME * sfx_vol / 100;
        sfx_mix_max        = MIX_MAX_VOLUME;
        music_mix_vol      = MIX_MAX_VOLUME * music_vol / 100;

        screen_size        = 10;

        use_textures   = true;
        use_lightmaps   = true;
        use_dynlights   = true;
        use_wireframe   = false;
        show_bounding   = false;
        use_pvs   = true;
        reverse_mouse_y  = false;

        draw_walls = true;
        draw_floors = true;
}

#undef __ClientState_cc__
