/*
 * client/DungeonScreen.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __DungeonScreen_h__
#define __DungeonScreen_h__

#include "GenericScreen.h"

class DungeonScreen : public GenericScreen {
        GLuint _playerList;
        
public:
        DungeonScreen( int w, int h, Client::State escape, Client::State close );
        ~DungeonScreen();
        void paint();
        virtual bool keyPressed(   SDL_KeyboardEvent * evt, int x, int y );
        virtual bool keyReleased(   SDL_KeyboardEvent * evt );
        void updateWidget();

        void initZone( class Player * player, class Zone * zone );
        void unloadZone( class Player * player, class Zone * zone );

        // class MouseButtonListener
        virtual bool mousePressed(  SDL_MouseButtonEvent * evt );
        virtual bool mouseReleased( SDL_MouseButtonEvent * evt );
        // class MouseMotionListener {
        virtual bool mouseMoved(    SDL_MouseMotionEvent * evt );
        virtual bool mouseEntered(  SDL_MouseMotionEvent * evt );
        virtual bool mouseExited(   SDL_MouseMotionEvent * evt );
};

#endif
