/*
 * client/GenericScreen.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __GenericScreen_h__
#define __GenericScreen_h__

#include "Client.h"

#include "../widgets/Widget.h"

class GenericScreen : public Widget {
protected:
        enum Client::State _escapeState;
        enum Client::State _closeState;
        
        GenericScreen( int w, int h, Client::State escape, Client::State close );
public:
        void setEscapeState( enum Client::State escape );
        void setCloseState( enum Client::State close );

        enum Client::State getEscapeState() const { return _escapeState; }
        enum Client::State getCloseState() const { return _closeState; }

        virtual void doEscapeAction();
        virtual void doCloseAction();

        virtual bool keyPressed(   SDL_KeyboardEvent * evt, int x, int y );

};
#endif
