/*
 * client/Renderer.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include <GL/gl.h>

#include "Renderer.h"

#include "ClientSector.h"
#include "../server/Sector.h"

#include "../GraphicsState.h"
#include "../gl_stubs.h"

#include <iostream>

/**
 * - GL_VERTEX_ARRAY client state must be enabled prior to calling this method
 */

void Renderer::drawHorizontalSurface( const class Sector * sect, 
                                      int which ) {

        
        const class ClientSector * cs = sect->clientSector;
        
        glVertexPointer( 2, GL_FLOAT, 0, cs->verts );
        
        if ( g_state.use_cva )
                glLockArraysEXT_ptr( 0, sect->verts.length );
        
        glMatrixMode( GL_MODELVIEW );
        glPushMatrix();
        
        if ( which == 0 ) {
                
                glTranslatef( 0, 0, sect->getFloorHeight() );
                
                //
                // floors are wound backwards?
                //
                
                glFrontFace( GL_CW );
                glDrawArrays( GL_POLYGON, 0, sect->verts.length );
                glFrontFace( GL_CCW );
        }
        else {
                glTranslatef( 0, 0, sect->getCeilingHeight() );
                glDrawArrays( GL_POLYGON, 0, sect->verts.length );
        }

        if ( g_state.use_cva )
                glUnlockArraysEXT_ptr();

        glPopMatrix();
}
