/*
 * client/Renderer.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Renderer_h__
#define __Renderer_h__

#include "../util/Array.h"

class Renderer {

public:
        virtual void drawSectors( const class Zone * zone,
                                  const class Player * player,
                                  const class Sector * pSect ) = 0;
        
        virtual void drawWalls( const class Zone * zone,
                                const class Player * player,
                                const class Sector * pSect,
                                const Array< class LineDef *> & drawLines ) = 0;

        static void drawHorizontalSurface( const class Sector * sect, 
                                           int which );

        static void drawHorizontalSurface( const class Sector * sect, 
                                           const float * texcoords,
                                           int which );
        
        virtual void setup() = 0;
        virtual void cleanup() = 0;

};

#endif
