
#define __gl_stubs_cc__
#include <iostream>
#include <gl_stubs.h>

#ifdef WIN32
#include <windows.h>
#endif
  
#include <SDL/SDL.h>
#include <GL/gl.h>

#include "GraphicsState.h"

//
// setup gl extension function ptrs
//

void setup_gl_stubs() {
        GLenum gl_error;

        if ( ( gl_error = glGetError( ) ) )
                cout << " GL_ERROR0: " << (int) gl_error << endl;
            
        glActiveTextureARB_ptr =
                (GL_ACTIVETEXTUREARB_FUNC) SDL_GL_GetProcAddress( "glActiveTextureARB" );
        glMultiTexCoord2fARB_ptr = 
                (GL_MULTITEXCOORD2FARB_FUNC) SDL_GL_GetProcAddress( "glMultiTexCoord2fARB" );
        glClientActiveTextureARB_ptr =
                (GL_CLIENTACTIVETEXTUREARB_FUNC) SDL_GL_GetProcAddress( "glClientActiveTextureARB" );

        glLockArraysEXT_ptr =
                (GL_LOCKARRAYSEXT_FUNC) SDL_GL_GetProcAddress( "glLockArraysEXT" );
        glUnlockArraysEXT_ptr =
                (GL_UNLOCKARRAYSEXT_FUNC) SDL_GL_GetProcAddress( "glUnlockArraysEXT" );
        
        if ( glActiveTextureARB_ptr == 0 ||
             glMultiTexCoord2fARB_ptr == 0 ||
             glClientActiveTextureARB_ptr == 0 ) {
                g_state.has_multitex = false;
        }
        else {
                g_state.has_multitex = true;
        }

        if ( glLockArraysEXT_ptr == 0 ||
             glUnlockArraysEXT_ptr == 0 ) {
                g_state.has_cva = false;
        }
        else {
                g_state.has_cva = true;
        }
}

#undef __gl_stubs_cc__
