/*
 * main.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "DG.h"

#ifdef WIN32
#define PSEP "\\"
#define PSEP2 PSEP
#include <windows.h>
#include <io.h>
#else
#include <unistd.h>
#define PSEP "src/dg"
#define PSEP2 "/"

#endif

#include <string>

/**
 * main.cc
 */

int main( int argc, char **argv )
{
        

        //
        // first chdir to the appropriate place (parent dir of lib/...)
        //

        string arg( argv[0] );
        
        size_t psep_pos = arg.rfind( PSEP );
        
        if ( psep_pos == string::npos )
                psep_pos = arg.rfind( PSEP2 );

        chdir( arg.substr( 0, psep_pos ).c_str() );

        //
        //
        //

        DG *dg = 0;

        dg = new DG( argc, argv );

        if ( dg->ok == false ) {
                cout << " :: Error in main constructing DG. " << endl;
                exit( 1 );
        }

        int val = dg->startGameLoop( argc, argv );
        
        delete dg;

        return val;
}
