/*
 * server/Item.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "Item.h"
#include "ProtoItem.h"

#include <cstdio>

/**
 * default radius = 0, height = 0, angle = 0
 */

Item::Item( const char * name, const char * alias, float radius, int height, float angle ) 
        : Entity( name, alias, radius, height, angle ),
          _wearable( WEAR_NONE ),
          _wornBy( 0 ),
          _wornPos( WEAR_NONE )
{

}

Item::Item( class ProtoItem * proto )
        : Entity( proto ),
          _wearable( (WornPosition) proto->wearflag ),
          _wornBy( 0 ),
          _wornPos( WEAR_NONE )
{
}

Item::~Item() {
}

void Item::setWeight( int weight ) {
        Entity::setWeight( weight );
        
        if ( _wornBy ) {}
}
                
bool Item::collideWith( class Entity * other, const float * normal ) {
        return false;
}
