/*
 * server/Lightmap.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Lightmap_h__
#define __Lightmap_h__

class Lightmap {
public:
        static const int TEX_RES = 16;

        static const int MODIFIED      = 0x0001;
        static const int NEEDS_REBIND  = 0x0002;
        static const int GAMMA_APPLIED = 0x0004;
        
        mutable char flags;
        
        short size[2];
        short use_size[2];
        
        unsigned char *static_pixels;
        unsigned char *rgb_pixels;

        class ClientLightmap * clientLightmap;

        Lightmap();
        ~Lightmap();
        
        void load( class istream & is );
        void writeLightmap( class ostream & os );
        void clampEdges( unsigned char * pix );
        void clear( unsigned char r, unsigned char g, unsigned char b );
        void setSize( int x, int y );

        inline bool isModified() const { return flags & MODIFIED; }
        inline bool needsRebind() const { return flags & NEEDS_REBIND; }
        inline bool gammaApplied() const { return flags & GAMMA_APPLIED; }
        
        inline void setFlag( int flag ) const { flags |= flag; }
        inline void removeFlag( int flag ) const { flags &= ~flag; }
};

#endif
