/*
 * server/Script.h
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */
 
#ifndef __Script_h__
#define __Script_h__

struct Script {

        struct Command {
                enum Type {
                        NONE            ,
                        CENTERPRINT     ,
                        CAMERA_MODE     ,
                        ROTATE_CAMERA   ,
                        ZOOM_CAMERA     ,
                        SET_CAMERA_ANGLE,
                        SET_CAMERA_ZOOM ,
                        ROTATE_PLAYER   ,
                        SET_PLAYER_ANGLE,
                        PLAYER_WALK     ,
                        WAIT            ,
                        TRIGGER_DOOR    ,
                        TELEPORT        ,
                        SPAWN_SECT      ,
                        WAKE_MONSTER    ,
                        LIGHT           ,
                        SOUND           ,
                        LOOP            ,
                        ALLOW_CONTROL   ,
                        CHECK_KEY       ,
                        TERMINATE       ,
                        CHANGE_MAP      
                };

                Type type;
                short values[4];
                
                Command( class istream & is );
                Command( const Command & other );
                void writeCommand( class ostream & os ) const;
                bool execute( struct Script * script, unsigned int tick );
        };
        
        char num_cmds;
        char num_msgs;
        struct Command ** cmds;
        char ** msgs;

        int cur_cmd;
        int iterations;
        int loop_start;
        int loop_span;
        bool running;

        unsigned int next_tick;
        class Entity * ent;

        Script( class istream & is );
        Script( const Script & other );
        ~Script();
        void writeScript( class ostream & os ) const;

        bool execute( class Entity * ent, unsigned int tick );
};

#endif
