/*
 * server/Sector.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Sector_h__
#define __Sector_h__

#include "../util/Array.h"

class Sector {
        friend class Zone;
        class Zone * _zone;
        short _surfaceHeights[2];
        float _centerPoint[3];
public:

        enum SurfaceType {
                FLOOR = 0,
                CEILING = 1
        };

        int _num;
        
        float _offset[2];
        float _extent[2];
        
        class Array<float *> verts;
        
        const char * floorTex;
        const char * ceilingTex;
        
        class Lightmap * floor_lightmap;
        class Lightmap * ceiling_lightmap;
        
        class ClientSector * clientSector;

        class SectorSpecial * spec;
        
        class Array<short> _visibleSectors;
        class Array<short> _visibleFloors;
        class Array<short> _visibleCeilings;
        class Array<short> _visibleLines;
        class Array<short> _myLines;
        
        //        float ** verts;

        Sector( class istream & is,
                const class Array<float *> & vs,
                const class Array<const char *> & ts,
                const class Array<class Lightmap *> &lm,
                class Zone * );

        ~Sector();

        inline short getFloorHeight()   const { return _surfaceHeights[0]; }
        inline short getCeilingHeight() const { return _surfaceHeights[1]; }
        inline short getSurfaceHeight( enum SurfaceType which ) const { return _surfaceHeights[ which ]; }

        inline const char * getFloorTex()   const { return floorTex; }
        inline const char * getCeilingTex() const { return ceilingTex; }
        inline const char * getTex( enum SurfaceType which ) const { return ( which == FLOOR ? floorTex : ceilingTex ); }
        
        void writeSector( class ostream & os ) const;

        bool canSeeSector( const class Sector * osect ) const;

        const float * getCenterPoint() const { return _centerPoint; }

        class Zone * getZone() const { return _zone; }

        int getSurfaceVelocity( enum SurfaceType which ) const;

};
#endif


















