/*
 * server/World.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __World_h__
#define __World_h__

#include "Entity.h"
#include "../util/Array.h"

class World : public Entity {
public:
        World( const char * name, const char * alias );
        virtual ~World();

        bool addZone( class Zone * zone );
        bool removeZone( class Zone * zone );
        
        /**
         * null keyword matches any zone
         */
        class Zone * getZone( const char * keyword );
        
        Array<class ProtoItem *> _protoItems;
        Array<class ProtoChar *> _protoChars;
        
        class ProtoItem * getProtoItem( int vnum ) const;
        class Item * createNewItem( int vnum ) const;

        class ProtoChar * getProtoChar( int vnum ) const;
        class Character * createNewChar( int vnum ) const;
                
};

#endif
