/*
 * util/Array.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Array_h__
#define __Array_h__

/**
 * a fixed size array
 *
 */
template<class T> class Array {

public:
        T * values;
        int length;
        int cur_index;

        
        Array()
                : values(0),
                  length(0),
                  cur_index( 0 )
        {}
        
        Array( int size ) 
                : values(0),
                  length(0)
        {
                setSize( size );
        }

        Array( const Array<T> & other )
                : values( 0 ),
                  length( 0 )
        {
                clone( other );
        }
        
        inline T & operator[]( int index ) const {
                return values[index];
        }

        void clone( const Array<T> & other ) {
                
                setSize( other.length );

                cur_index = 0;

                for ( ; cur_index < other.cur_index; ++cur_index )
                        values[ cur_index ] = other[ cur_index ];
                
        }

        void setSize( int size ) {

                if ( length ) {
                        delete[] values;
                }

                cur_index = length = size;
                
                if ( size > 0 ) {
                        
                        values = new T[ size ];
                        
                        for ( int i = 0; i < size; ++i ) {
                                values[i] = (T) 0;
                        }
                }
        }

        ~Array() {
                setSize( 0 );
        }

        int findElement( T t ) const {
                for ( int i = 0; i < cur_index; ++i ) {
                        if ( values[i] == t )
                                return i;
                }
                return -1;
        }

        void addElement( T t ) {
                if ( cur_index < length )
                        values[ cur_index++ ] = t;
        }
        
        void shrinkWrap() {
                if ( cur_index < length ) {
                        
                        if ( cur_index > 0 ) {
                                
                                T * nv = new T[ cur_index ];

                                for ( int i = 0; i < cur_index; ++i )
                                        nv[i] = values[i];
                                
                                delete[] values;
                                values = nv;
                                length = cur_index;
                        }
                        else {
                                setSize( 0 );
                        }
                }
        }
};

#endif






