/*
 * util/ModelManager.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __ModelManager_h__
#define __ModelManager_h__

#include <string>
#include "md2_model.h"

class ModelManager {
        const static int MAX_MODELS = 32;
        static class md2_model_t * _models[ MAX_MODELS ];
        static int _num_models;
public:

        static const char * const MODEL_DIR;

        static inline md2_model_t * findModel( const char * name ) {

                if ( name == 0 )
                        name = "null";

                int i = _num_models;
                
                while ( i ) {
                        if ( strcmp( _models[ --i ]->_filename, name ) == 0 )
                                return _models[i];
                }

                return 0;
        }
        
        static md2_model_t * getModel( const char * name );
        
        static void purge();
};

#endif 
