/*
 * util/Persist.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Persist_h__
#define __Persist_h__

#include <iostream>
#include <iomanip>
#include <fstream>

namespace Persist {

        char * readString( istream & is, char * buf, int len );
        void writeString( ostream & os, const char * buf, int len = -1 );

        short readShort( istream & is );
        float readFloat( istream & is );

        void writeShort( ostream & os, short s );
        void writeFloat( ostream & os, float f );

};
#endif
