/*
 * util/Texload.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __Texload_h__
#define __Texload_h__

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>

enum PNM_t {
        PNM_ERR = 0,
        PNM_PPM = 6,
        PNM_PGM = 5,
        PNM_PBM = 4
};

class ifstream;

namespace Texload {
        char * readPNMLine( ifstream & ifs, char * buf, int bufsize );
        GLubyte * loadPNG( const char *filename, int *width, int *height, int *components, bool flip );

        GLubyte * loadPNM( const char *filename, int *width, int *height, PNM_t *pnmType, bool flip );

        GLubyte * loadPPM( const char *filename, int *width, int *height, bool flip );

        GLubyte * loadPGM( const char *filename, int *width, int *height, bool flip );
        void flipImage( GLubyte *pixels, int width, int height, int components );
        void applyGamma( unsigned char * pixels, float gamma, int w, int h, int components );

        
};
#endif



