/*
 * util/TextureFont.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __TextureFont_h__
#define __TextureFont_h__

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>

class TextureFont {

        GLuint _textureIndex;
        const static int MAX_GLYPHS = 256;
        
        GLuint _glyphsIndex;
        int    _numGlyphLists;
        
        char _leads[256];
        char _widths[256];

        int _height;

        /**
         * returns false if init fails
         */
        bool initGlyphLists( int num );
public:
        
        bool ok;
        /**a

         * This method RELIES on the str being null terminated
         */
        unsigned int getStringWidth( const char * const str ) const;
        
        /**
         * the height of all glyphs
         */
        inline int getFontHeight() const { return _height; }

        /**
         * This currently supports FIXED-WIDTH only.
         */
        inline int getFontWidth() const { return _widths[0]; }        

        void drawString( const char * const str, int maxlen = 0 ) const;

        inline void drawStringFragment( const char * const str, int offset, int length ) const {
                glCallLists( length, GL_BYTE, str + offset );
        }

        void startStringDraw() const;
        void endStringDraw() const;

        TextureFont( const char * const fontName );

        ~TextureFont();
};

#endif

