/*
 * util/TextureManager.h:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#ifndef __TextureManager_h__
#define __TextureManager_h__

#ifdef WIN32
#include <windows.h>
#endif

#include <GL/gl.h>

#include <string>

#include "TextureObject.h"

class TextureManager {
        const static int MAX_TEXTURES = 128;
        static class TextureObject * _textures[ MAX_TEXTURES ];
        static int _num_textures;

        static GLuint _dummy_tex;
public:
        static const string GFX_DIR;

        static inline class TextureObject * findTexture( const char * name ) {

                int i = _num_textures;
                
                while ( i ) {
                        if ( strcmp( _textures[ --i ]->_name, name ) == 0 )
                                return _textures[i];
                }

                return 0;
        }
        
        static class TextureObject * getTexture( const char * name , GLenum type );
        
        /**
         * must be called before use, but after GL is initialized
         */
        static void init();

        static inline GLuint getDummyTexture() { return _dummy_tex; }
        
        static void purge();
};

#endif 


