#ifndef __md2_file_h__
#define __md2_file_h__

#include <iostream>

struct md2_frame_t;
struct md2_gl_cmd_t;

namespace md2_file {
        const int MD2_MAGIC = 844121161;
        const int MAX_TRIANGLES = 4096;
        const int MAX_VERTICES = 2048;
        const int MAX_TEXCOORDS = 2048;
        const int MAX_FRAMES = 512;
        const int MAX_SKINS = 32;
        const int Q2_VERSION = 8;
        
        struct model_t { 
                int magic;
                int version;
                int skinWidth;
                int skinHeight;
                int frameSize;
                int numSkins;
                int numVertices;
                int numTexCoords;
                int numTriangles;
                int numGLCommands;
                int numFrames;
                int offsetSkins;
                int offsetTexCoords;
                int offsetTriangles;
                int offsetFrames;
                int offsetGLCommands;
                int offsetEnd;
        };
        
        
        void loadFrames( istream & is, model_t & md, md2_frame_t * frames );
        int loadGLCmds( istream & is, model_t & md, md2_gl_cmd_t ** gl_cmds );
        
        struct triangleVertex_t {
                unsigned char vertex[3];
                unsigned char lightNormalIndex;
        };
        
        struct frame_t {
                float scale[3];
                float translate[3];
                char name[16];
        };

        struct triangle_t {
                short vertexIndices[3];
                short textureIndices[3];
        };

        struct textureCoordinate_t {
                short s, t;
        };

        struct glCommandVertex_t {
                float s, t;
                int vertexIndex;
        };
};

#endif



