/*
 * widgets/LabelWidget.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "Widget.h"
#include "LabelWidget.h"

#include "../util/TextureFont.h"

void LabelWidget::paint() 
{
        if ( _paintBase )
                Widget::paint();
        
        if ( _text ) {
                
                unsigned int strlength = _font->getStringWidth( _text );

                int maxlen = min( strlength, (unsigned int) _size[0] - 2 );
                
                int pad[2] = { ( _size[0] - maxlen ) / 2,
                               ( _size[1] - _font->getFontHeight() ) / 2 };
                
                if ( isEnabled() )
                        glColor4fv( getFGColor4fv() );
                else
                        glColor4fv( _lookAndFeel->getBlackColor() );
                
                glTranslatef( pad[0], pad[1], 0 );

                _font->drawString( _text );

        }
}

void LabelWidget::setText( const char *text ) {
        if ( _text )
                free( _text );
        _text = text ? strdup( text ) : 0;
}

LabelWidget::LabelWidget() : Widget( 0, 0 ) {
        _text = 0;
        _paintBase = true;
        setDrawMargin( false );
        _name = "LabelWidget";
        setIgnoreEvents( true );
}

/**
 * default label = 0
 */
LabelWidget::LabelWidget( int w, int h, const char *label ) : Widget( w, h ) {
        _text = label ? strdup( label ) : 0;
        _paintBase = true;
        setDrawMargin( false );
        _name = "LabelWidget";
        setIgnoreEvents( true );
}

LabelWidget::~LabelWidget() {
        if ( _text )
                free( _text );
}

