/*
 * widgets/WidgetEvents.cc:
 *
 * Copyright (C) 2000 John Watson, jwatson@tempusmud.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 * 
 */

#include "WidgetEvents.h"
#include "Widget.h"

ResizeEvent::ResizeEvent( const class Widget * source, 
                          int old_x, 
                          int old_y ) : WidgetEvent( source, EVENT_RESIZE ) {

        _oldSize[0] = old_x;
        _oldSize[1] = old_y;
        
        
        _sizeChanged[0] = ( _oldSize[0] != source->getSize()[0] );
        _sizeChanged[1] = ( _oldSize[1] != source->getSize()[1] );
}

ActionEvent::ActionEvent( const class Widget * source, const char * command ) : WidgetEvent( source, EVENT_ACTION ) {
        _actionCommand = strdup( command );
}

ActionEvent::~ActionEvent() {
        free( _actionCommand );
}

WidgetEventListener::WidgetEventListener() {
        for ( int i = 0; i < EVENT_NUM; ++i ) {
                _acceptedTypes[i] = false;
        }
        _enabled = true;
        ptr = this;
}

bool WidgetEventListener::eventTypeOk( enum WidgetEventType type ) const {
        if ( _enabled )
                return _acceptedTypes[type];

        return false;
}
